<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\Resource;

use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\MerchantOrderReturn;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsAcknowledgeRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsAcknowledgeResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsCreateOrderReturnRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsCreateOrderReturnResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsListResponse;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsProcessRequest;
use Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\ShoppingContent\OrderreturnsProcessResponse;

/**
 * The "orderreturns" collection of methods.
 * Typical usage is:
 *  <code>
 *   $contentService = new Google\Service\ShoppingContent(...);
 *   $orderreturns = $contentService->orderreturns;
 *  </code>
 */
class Orderreturns extends \Automattic\WooCommerce\GoogleListingsAndAds\Vendor\Google\Service\Resource
{
  /**
   * Acks an order return in your Merchant Center account.
   * (orderreturns.acknowledge)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $returnId The ID of the return.
   * @param OrderreturnsAcknowledgeRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrderreturnsAcknowledgeResponse
   * @throws \Google\Service\Exception
   */
  public function acknowledge($merchantId, $returnId, OrderreturnsAcknowledgeRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'returnId' => $returnId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('acknowledge', [$params], OrderreturnsAcknowledgeResponse::class);
  }
  /**
   * Create return in your Merchant Center account.
   * (orderreturns.createorderreturn)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param OrderreturnsCreateOrderReturnRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrderreturnsCreateOrderReturnResponse
   * @throws \Google\Service\Exception
   */
  public function createorderreturn($merchantId, OrderreturnsCreateOrderReturnRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('createorderreturn', [$params], OrderreturnsCreateOrderReturnResponse::class);
  }
  /**
   * Retrieves an order return from your Merchant Center account.
   * (orderreturns.get)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $returnId Merchant order return ID generated by Google.
   * @param array $optParams Optional parameters.
   * @return MerchantOrderReturn
   * @throws \Google\Service\Exception
   */
  public function get($merchantId, $returnId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'returnId' => $returnId];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], MerchantOrderReturn::class);
  }
  /**
   * Lists order returns in your Merchant Center account.
   * (orderreturns.listOrderreturns)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param array $optParams Optional parameters.
   *
   * @opt_param bool acknowledged Obtains order returns that match the
   * acknowledgement status. When set to true, obtains order returns that have
   * been acknowledged. When false, obtains order returns that have not been
   * acknowledged. When not provided, obtains order returns regardless of their
   * acknowledgement status. We recommend using this filter set to `false`, in
   * conjunction with the `acknowledge` call, such that only un-acknowledged order
   * returns are returned.
   * @opt_param string createdEndDate Obtains order returns created before this
   * date (inclusively), in ISO 8601 format.
   * @opt_param string createdStartDate Obtains order returns created after this
   * date (inclusively), in ISO 8601 format.
   * @opt_param string googleOrderIds Obtains order returns with the specified
   * order ids. If this parameter is provided, createdStartDate, createdEndDate,
   * shipmentType, shipmentStatus, shipmentState and acknowledged parameters must
   * be not set. Note: if googleOrderId and shipmentTrackingNumber parameters are
   * provided, the obtained results will include all order returns that either
   * match the specified order id or the specified tracking number.
   * @opt_param string maxResults The maximum number of order returns to return in
   * the response, used for paging. The default value is 25 returns per page, and
   * the maximum allowed value is 250 returns per page.
   * @opt_param string orderBy Return the results in the specified order.
   * @opt_param string pageToken The token returned by the previous request.
   * @opt_param string shipmentStates Obtains order returns that match any
   * shipment state provided in this parameter. When this parameter is not
   * provided, order returns are obtained regardless of their shipment states.
   * @opt_param string shipmentStatus Obtains order returns that match any
   * shipment status provided in this parameter. When this parameter is not
   * provided, order returns are obtained regardless of their shipment statuses.
   * @opt_param string shipmentTrackingNumbers Obtains order returns with the
   * specified tracking numbers. If this parameter is provided, createdStartDate,
   * createdEndDate, shipmentType, shipmentStatus, shipmentState and acknowledged
   * parameters must be not set. Note: if googleOrderId and shipmentTrackingNumber
   * parameters are provided, the obtained results will include all order returns
   * that either match the specified order id or the specified tracking number.
   * @opt_param string shipmentTypes Obtains order returns that match any shipment
   * type provided in this parameter. When this parameter is not provided, order
   * returns are obtained regardless of their shipment types.
   * @return OrderreturnsListResponse
   * @throws \Google\Service\Exception
   */
  public function listOrderreturns($merchantId, $optParams = [])
  {
    $params = ['merchantId' => $merchantId];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], OrderreturnsListResponse::class);
  }
  /**
   * Processes return in your Merchant Center account. (orderreturns.process)
   *
   * @param string $merchantId The ID of the account that manages the order. This
   * cannot be a multi-client account.
   * @param string $returnId The ID of the return.
   * @param OrderreturnsProcessRequest $postBody
   * @param array $optParams Optional parameters.
   * @return OrderreturnsProcessResponse
   * @throws \Google\Service\Exception
   */
  public function process($merchantId, $returnId, OrderreturnsProcessRequest $postBody, $optParams = [])
  {
    $params = ['merchantId' => $merchantId, 'returnId' => $returnId, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('process', [$params], OrderreturnsProcessResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Orderreturns::class, 'Google_Service_ShoppingContent_Resource_Orderreturns');
